package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.GrantCond;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.mapper.RamGrantMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamGrantCrudServiceImpl implements RamGrantCrudService {

    @Autowired
    private RamGrantMapper ramGrantMapper;

    @Override
    public long insert(Grant data) {
        BaseUtils.setCreateFields(data);
        ramGrantMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramGrantMapper.deleteBySid(sid);
    }

    @Override
    public long update(Grant data) {
        BaseUtils.setModifyFields(data);
        ramGrantMapper.update(data);
        return data.getSid();
    }

    @Override
    public Grant findBySid(long sid) {
        return ramGrantMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Grant data) {
        return ramGrantMapper.exists(data.getSid());
    }

    @Override
    public List<GrantVO> findByCond(GrantCond cond) {
        return ramGrantMapper.findByCond(cond);
    }

    @Override
    public PageData<GrantVO> findByPage(GrantCond page) {
        long total = ramGrantMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<GrantVO> paths = ramGrantMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }
}
