package com.digiwin.dap.middle.ram.service.executor.local;


import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.service.executor.RamGrantExecutor;
import com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder;
import com.digiwin.dap.middle.ram.support.cache.LocalCacheHolder;

import java.util.List;

public class RamGrantLocalCacheExecutor implements RamGrantExecutor {

    private final String appName;
    private final RamGrantExecutor delegate;

    public RamGrantLocalCacheExecutor(String appName, RamGrantExecutor delegate) {
        this.appName = appName;
        this.delegate = delegate;
    }

    @Override
    public List<PolicyVO> findPolicyByTargetId(String app, String targetType, String targetId) {
        String key = CacheKeyBuilder.getPolicyByTargetId(appName, app, targetType, targetId);
        return LocalCacheHolder.POLICY_BY_TARGET_ID.computeIfAbsent(key, k -> delegate.findPolicyByTargetId(app, targetType, targetId));
    }
}
