package com.digiwin.dap.middle.ram.support.iam;

import com.digiwin.dap.middle.ram.domain.remote.AppAuthResult;
import com.digiwin.dap.middleware.cache.RedisUtils;

import java.time.Duration;
import java.time.LocalDateTime;

/**
 * 鉴权相关的业务缓存
 */
public class RedisCache {

    /**
     * 授权缓存:tenantId:userId:sysId
     */
    private static final String TENANT_USER_SYS_AUTH = "cac:tenant:user:auth:%s::%s::%s";

    /**
     * 平台的应用缓存 平台ID
     */
    public static final String SOP_PLATFORM_PREFIX = "entity:sysonplatform:platform:";
    /**
     * 应用的平台缓存 应用ID
     */
    public static final String SOP_SYS_PREFIX = "entity:sysonplatform:sys:";

    public static AppAuthResult getAuthResult(String tenantId, String userId, String sysId) {
        String cacAuthKey = String.format(TENANT_USER_SYS_AUTH, tenantId, userId, sysId);
        return RedisUtils.get(cacAuthKey, AppAuthResult.class);
    }

    public static void setAuthResult(AppAuthResult result, String userId, String sysId) {
        String cacAuthKey = String.format(TENANT_USER_SYS_AUTH, result.getTenantId(), userId, sysId);
        RedisUtils.set(cacAuthKey, result, calcDuration(result.getExpiredDateTime()));
    }

    /**
     * 缓存时间计算，最多缓存一周
     * 1、如果过期时间大于7天，则返回 7天
     * 2、如果过期时间小于7天，则返回 过期时间-当前时间
     *
     * @param expiredDateTime 过期时间
     */
    public static Duration calcDuration(LocalDateTime expiredDateTime) {
        LocalDateTime now = LocalDateTime.now();
        if (now.plusDays(7).isBefore(expiredDateTime)) {
            return Duration.ofDays(7);
        }
        return Duration.between(now, expiredDateTime);
    }
}
