package com.digiwin.dap.middle.ram.support.security.auth;

import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.SecurityHandler;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;

/**
 * App授权检查
 *
 * @author fobgochod
 */
public abstract class AuthPolicyHandler implements SecurityHandler<AccessUser> {

    protected RamCoreService ramCoreService;

    /**
     * 是否支持此 授权检查处理器
     *
     * @param authType 授权检查结果
     * @return 是否支持此
     */
    public boolean supports(AuthType authType) {
        return authType == null;
    }

    /**
     * 查询是否有应用授权
     *
     * @param authResult 授权信息
     * @param request    当前请求信息
     * @return 授权检查结果
     */
    public AuthResult process(AuthResult authResult, AccessUser request) {
        return authResult;
    }
}
