package com.digiwin.dap.middle.ram.domain.enums;

/**
 * 策略类型
 *
 * @author fobgochod
 */
public enum PolicyType {

    /**
     * 白名单
     */
    AllowList,
    /**
     * 策略，系统策略(System)、自定义策略(Custom)
     */
    Base,

    /**
     * 跨租户访问管控
     */
    AcrossTenant,

    /**
     * 功能权限策略
     */
    Function,

    /**
     * 应用授权检查、需要AppToken
     * <p>
     * 1、如果没有购买，直接放过
     * 2、购买了就检查过期时间
     */
    NoAuthApp,
    /**
     * 用户授权检查、需要租户和AppToken
     * <p>
     * 1、租户需要购买应用
     * 2、不需要检查用户是否加入该应用
     */
    NoAuthUser;
}
