package com.digiwin.dap.middle.ram.domain.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Function {

    private FunctionItems result;

    /**
     * 获取权限缓存，解析actionId和conditionId集合
     *
     * @return 目标权限ID
     */
    public List<String> uris(String app) {
        List<String> uris = new ArrayList<>();
        List<FunctionItem> permissions = result.getPermissions();
        if (permissions.isEmpty()) {
            // 空则不含任何权限
            return uris;
        }
        // 添加应用
        String appId = "drn:iam:app:" + app;
        uris.add(appId);
        // 添加模组
        List<String> moduleIds = permissions.stream()
                .map(p -> appId + ":" + p.getModuleId())
                .distinct().collect(Collectors.toList());
        uris.addAll(moduleIds);
        // 添加行为
        permissions.forEach(action -> {
            uris.add(action.getTarget());
            // 添加行为状态
            action.getConditions().forEach((key, value) -> {
                value.entrySet().stream()
                        .filter(condition -> "allow".equals(condition.getValue()))
                        .map(condition -> key + ":" + condition.getKey())
                        .forEach(uris::add);
            });
        });
        return uris;
    }

    public FunctionItems getResult() {
        return result;
    }

    public void setResult(FunctionItems result) {
        this.result = result;
    }
}
