package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyCond;
import com.digiwin.dap.middle.ram.entity.Policy;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamPolicyMapper {

    int insert(@Param("entity") Policy entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Policy entity);

    Policy findBySid(@Param("sid") long sid);

    boolean exists(@Param("sid") long sid);

    Policy findByAppAndId(@Param("app") String app, @Param("policyId") String policyId);

    long countByPage(@Param("cond") PolicyCond cond);

    List<PolicyVO> findByCond(@Param("cond") PolicyCond cond);

    List<PolicyVO> findByPage(@Param("cond") PolicyCond cond, @Param("pageable") Pageable pageable);
}
