package com.digiwin.dap.middle.ram.service.executor.redis;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.service.executor.RamPolicyExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class RamPolicyRedisCacheExecutor implements RamPolicyExecutor {

    private final RamPolicyExecutor delegate;

    public RamPolicyRedisCacheExecutor(RamPolicyExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getRouteByPolicyId(#app, #policyId)")
    @Override
    public List<PatternVO> findRouteByPolicyId(String app, String policyId) {
        return delegate.findRouteByPolicyId(app, policyId);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getRouteByPolicyType(#app, #policyType)")
    @Override
    public List<PatternVO> findRouteByPolicyType(String app, String policyType) {
        return delegate.findRouteByPolicyType(app, policyType);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getPolicyByPath(#app, #method, #path)")
    @Override
    public List<PolicyVO> findPolicyByPath(String app, String method, String path) {
        return delegate.findPolicyByPath(app, method, path);
    }
}
