package com.digiwin.dap.middle.ram.support.security.auth.handler;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import org.springframework.core.annotation.Order;

import java.util.List;

/**
 * 不做应用购买检查和用户加入检查<br>
 * 策略类型 {@link PolicyType#NoAuthApp}<br>
 * <ol>
 *     <li>指定应用不检查授权</li>
 *     <li>指定应用的API不检查授权</li>
 * </ol>
 *
 * @author fobgochod
 */
@Order(15)
public class NoAuthAppAuthPolicyHandler extends AuthPolicyHandler {

    public NoAuthAppAuthPolicyHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return authType == AuthType.AppNone;
    }

    @Override
    public AuthResult process(AuthResult authResult, AccessUser request) {
        List<String> policyIds = ramCoreService.findPolicyId(request.getApp(), PolicyType.NoAuthApp.name(), TargetType.Sys.name(), request.getSysId());
        if (!policyIds.isEmpty()) {
            if (policyIds.contains(PolicyType.NoAuthApp.name())) {
                // 兼容旧，策略ID=NoAuthApp，所有API不检查授权
                authResult.setAuthType(AuthType.AppOk);
            } else {
                // 否则，匹配上的API才不检查授权
                Statement statement = ramCoreService.getPolicyRoute(request.getApp(), policyIds);
                PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow());
                if (matched != null) {
                    authResult.setAuthType(AuthType.AppOk);
                }
            }
        }
        return authResult;
    }
}
