/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security.path.handler;

import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.TargetChain;
import com.digiwin.dap.middle.ram.support.security.TargetHandler;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import org.springframework.core.annotation.Order;

@Order(value=200)
public class AllowListPathPolicyHandler
extends PathPolicyHandler<AccessUser>
implements TargetHandler<AccessInfo> {
    public AllowListPathPolicyHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public AccessResult handle(AccessUser request) {
        PatternVO matched;
        MappingRegistry mappingRegistry = this.ramCoreService.getPattern(request.getApp(), PolicyType.AllowList.name());
        if (!mappingRegistry.isEmpty() && (matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry)) != null) {
            TargetChain<AccessInfo> chain = new TargetChain<AccessInfo>(this, TargetInfo.getTargets(request));
            AccessResult accessResult = chain.doNextStep(request);
            return accessResult.getResultType() == ResultType.ALLOW ? accessResult : AccessResult.deny(matched.getPolicyId());
        }
        return AccessResult.next();
    }

    @Override
    public AccessResult handle(TargetType targetType, String targetId, AccessInfo request) {
        PatternVO matched;
        Statement statement = this.ramCoreService.getPolicyRoute(request.getApp(), PolicyType.AllowList.name(), targetType.name(), targetId);
        if (!statement.getAllow().isEmpty() && (matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow())) != null) {
            return AccessResult.allow();
        }
        return AccessResult.next();
    }
}

