/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security.policy;

import com.digiwin.dap.middle.ram.domain.request.AccessPath;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.SecurityHandler;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessPathPolicyHandler
implements SecurityHandler<AccessPath> {
    @Autowired
    private RamCoreService ramCoreService;

    @Override
    public AccessResult handle(AccessPath request) {
        List<String> policyIds = this.ramCoreService.findPolicyIdByRoute(request.getApp(), request.getPolicyType().name(), request.getMethod(), request.getPath());
        ArrayList<String> targetIds = new ArrayList<String>();
        for (String policyId : policyIds) {
            targetIds.addAll(this.ramCoreService.findTargetByPolicyId(request.getApp(), request.getTargetType().name(), policyId));
        }
        if (targetIds.contains(request.getTargetId())) {
            return AccessResult.allow();
        }
        return AccessResult.next();
    }
}

