/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.BaseSid;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.GrantPolicyCond;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/gp"})
@RestController
public class RamGrantPolicyController {
    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody GrantPolicy body) {
        long sid = this.ramGrantPolicyCrudService.insert(body);
        this.ramCacheService.grantPolicyChange(body.getGrantSid());
        return StdData.ok((Object)BaseSid.ok(sid));
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        GrantPolicy grantPolicy = (GrantPolicy)this.ramGrantPolicyCrudService.findBySid(body.getSid());
        if (grantPolicy == null) {
            return StdData.ok((Object)BaseSid.ok(0L));
        }
        this.ramGrantPolicyCrudService.deleteBySid(body.getSid());
        this.ramCacheService.grantPolicyChange(grantPolicy.getGrantSid());
        return StdData.ok((Object)BaseSid.ok(body.getSid()));
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody GrantPolicyCond body) {
        return StdData.ok(this.ramGrantPolicyCrudService.findByPage(body));
    }

    @PostMapping(value={"/find/grant"})
    public StdData<?> getGrant(@RequestBody GrantPolicy body) {
        List<GrantVO> grants = this.ramGrantPolicyCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ok(grants);
    }

    @PostMapping(value={"/find/policy"})
    public StdData<?> getPolicy(@RequestBody GrantPolicy body) {
        List<PolicyVO> policies = this.ramGrantPolicyCrudService.findByGrantSid(body.getGrantSid());
        return StdData.ok(policies);
    }
}

