/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.PolicyRouteVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyRouteCond;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.mapper.RamPolicyRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamPolicyRouteCrudServiceImpl
implements RamPolicyRouteCrudService {
    @Autowired
    private RamPolicyRouteMapper ramPolicyRouteMapper;

    @Override
    public long insert(PolicyRoute data) {
        BaseUtils.setCreateFields(data);
        this.ramPolicyRouteMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramPolicyRouteMapper.deleteBySid(sid);
    }

    @Override
    public long update(PolicyRoute data) {
        this.ramPolicyRouteMapper.update(data);
        return data.getSid();
    }

    @Override
    public PolicyRoute findBySid(long sid) {
        return this.ramPolicyRouteMapper.findBySid(sid);
    }

    @Override
    public boolean exists(PolicyRoute data) {
        return this.ramPolicyRouteMapper.exists(data.getPolicySid(), data.getRouteSid());
    }

    @Override
    public int deleteByPolicySid(long policySid) {
        return this.ramPolicyRouteMapper.deleteByPolicySid(policySid);
    }

    @Override
    public int deleteByPolicySidAndRouteSid(long policySid, long routeSid) {
        return this.ramPolicyRouteMapper.deleteByPolicySidAndRouteSid(policySid, routeSid);
    }

    @Override
    public List<PolicyVO> findByRouteSid(long routeSid) {
        return this.ramPolicyRouteMapper.findByRouteSid(routeSid);
    }

    @Override
    public List<RouteVO> findByPolicySid(long policySid) {
        return this.ramPolicyRouteMapper.findByPolicySid(policySid);
    }

    @Override
    public PageData<PolicyRouteVO> findByPage(PolicyRouteCond page) {
        long total = this.ramPolicyRouteMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<PolicyRouteVO> paths = this.ramPolicyRouteMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }
}

