/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.support.security.TargetHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TargetChain<T extends AccessInfo> {
    private static final Logger logger = LoggerFactory.getLogger(TargetChain.class);
    private final List<TargetInfo> targets;
    private final int size;
    private final TargetHandler<T> handler;
    private int currentPosition = 0;

    public TargetChain(TargetHandler<T> handler, List<TargetInfo> targets) {
        this.handler = handler;
        this.targets = targets;
        this.size = targets.size();
    }

    public AccessResult doNextStep(T request) {
        AccessResult result;
        if (this.currentPosition == this.size) {
            return AccessResult.next();
        }
        ++this.currentPosition;
        TargetInfo next = this.targets.get(this.currentPosition - 1);
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking {} {} ({}/{})", new Object[]{((AccessInfo)request).getId(), next.toString(), this.currentPosition, this.size});
        }
        if (ResultType.IMPLICIT_DENY == (result = this.handler.handle(next.getTargetType(), next.getTargetId(), request)).getResultType()) {
            return this.doNextStep(request);
        }
        return result;
    }
}

