package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.GrantPolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.GrantPolicyCond;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.mapper.RamGrantPolicyMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamGrantPolicyCrudServiceImpl implements RamGrantPolicyCrudService {

    @Autowired
    private RamGrantPolicyMapper ramGrantPolicyMapper;

    @Override
    public long insert(GrantPolicy data) {
        BaseUtils.setCreateFields(data);
        ramGrantPolicyMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramGrantPolicyMapper.deleteBySid(sid);
    }

    @Override
    public long update(GrantPolicy data) {
        ramGrantPolicyMapper.update(data);
        return data.getSid();
    }

    @Override
    public GrantPolicy findBySid(long sid) {
        return ramGrantPolicyMapper.findBySid(sid);
    }

    @Override
    public boolean exists(GrantPolicy data) {
        return ramGrantPolicyMapper.exists(data.getGrantSid(), data.getPolicySid());
    }

    public int deleteByGrantSid(long grantSid) {
        return ramGrantPolicyMapper.deleteByGrantSid(grantSid);
    }

    public List<GrantVO> findByPolicySid(long policySid) {
        return ramGrantPolicyMapper.findByPolicySid(policySid);
    }

    public List<PolicyVO> findByGrantSid(long grantSid) {
        return ramGrantPolicyMapper.findByGrantSid(grantSid);
    }

    public PageData<GrantPolicyVO> findByPage(GrantPolicyCond page) {
        long total = ramGrantPolicyMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<GrantPolicyVO> paths = ramGrantPolicyMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }
}
