/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security.auth.handler;

import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=15)
public class NoAuthAppAuthPolicyHandler
extends AuthPolicyHandler {
    public NoAuthAppAuthPolicyHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return authType == AuthType.AppNone;
    }

    @Override
    public AuthResult process(AuthResult authResult, AccessUser request) {
        List<String> policyIds = this.ramCoreService.findPolicyId(request.getApp(), PolicyType.NoAuthApp.name(), TargetType.Sys.name(), request.getSysId());
        if (!policyIds.isEmpty()) {
            if (policyIds.contains(PolicyType.NoAuthApp.name())) {
                authResult.setAuthType(AuthType.AppOk);
            } else {
                Statement statement = this.ramCoreService.getPolicyRoute(request.getApp(), policyIds);
                PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow());
                if (matched != null) {
                    authResult.setAuthType(AuthType.AppOk);
                }
            }
        }
        return authResult;
    }
}

