package com.digiwin.dap.middle.ram.domain.request;

import com.digiwin.dap.middle.ram.constant.RamConstant;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;

public class AccessUser extends AccessInfo {

    /**
     * 登录用户信息
     */
    private String userToken;
    private long userSid;
    private String userId;
    private String userName;
    /**
     * 登录租户信息
     */
    private long tenantSid;
    private String tenantId;
    private String tenantName;
    /**
     * 访问应用信息
     */
    private String appToken;
    private long sysSid;
    private String sysId;
    private boolean inside;
    // 授权检查使用，中间件内部需要传递，外部接口管控不需要
    private boolean platform;
    /**
     * 授权结构信息
     */
    private AuthResult authResult;

    public static AccessUser of(String appId, String method, String path) {
        AccessUser requestInfo = new AccessUser();
        requestInfo.setAppId(appId);
        requestInfo.setMethod(method);
        requestInfo.setPath(path);
        AppAuthContext context = AppAuthContextHolder.getContext();
        requestInfo.of(context.getAuthoredUser(), context.getAuthoredSys());
        return requestInfo;
    }

    /**
     * 通过iam解析结果，刷新参数信息
     *
     * @param authoredUser 登录租户用户
     * @param authoredSys  访问应用
     */
    public void of(AuthoredUser authoredUser, AuthoredSys authoredSys) {
        if (authoredUser != null) {
            this.setTenantSid(authoredUser.getTenantSid());
            this.setTenantId(authoredUser.getTenantId());
            this.setTenantName(authoredUser.getTenantName());
            this.setUserToken(authoredUser.getToken());
            this.setUserSid(authoredUser.getSid());
            this.setUserId(authoredUser.getUserId());
            this.setUserName(authoredUser.getUserName());
        }
        if (authoredSys != null) {
            this.setAppToken(authoredSys.getToken());
            this.setSysSid(authoredSys.getSid());
            this.setSysId(authoredSys.getId());
            this.setInside(authoredSys.isInside());
            this.setPlatform(authoredSys.isPlatform());
        }
    }

    public String getUserToken() {
        return userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public long getUserSid() {
        return userSid;
    }

    public void setUserSid(long userSid) {
        this.userSid = userSid;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getAppToken() {
        return appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public long getSysSid() {
        return sysSid;
    }

    public void setSysSid(long sysSid) {
        this.sysSid = sysSid;
    }

    public String getSysId() {
        return sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public boolean isInside() {
        return inside;
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    public boolean isPlatform() {
        return platform;
    }

    public void setPlatform(boolean platform) {
        this.platform = platform;
    }

    public AuthResult getAuthResult() {
        return authResult;
    }

    public void setAuthResult(AuthResult authResult) {
        this.authResult = authResult;
    }

    public String securityLog() {
        return "{"
                + "\"type\":\"" + RamConstant.SECURITY_LOG_PREFIX + '\"'
                + ",\"method\":\"" + this.getMethod() + '\"'
                + ",\"path\":\"" + this.getPath() + '\"'
                + ",\"userId\":\"" + this.getUserId() + '\"'
                + ",\"userName\":\"" + this.getUserName() + '\"'
                + ",\"tenantId\":\"" + this.getTenantId() + '\"'
                + ",\"tenantName\":\"" + this.getTenantName() + '\"'
                + ",\"userToken\":\"" + this.getUserToken() + '\"'
                + ",\"appToken\":\"" + this.getAppToken() + '\"'
                + ",\"logEnd\":\"" + RamConstant.SECURITY_LOG_SUFFIX + '\"'
                + "}";
    }
}
