package com.digiwin.dap.middle.ram.support.security.policy;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.request.AccessPath;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.SecurityHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 白名单，策略类型 {@link PolicyType#AcrossTenant}
 * <p>
 * 该策略下的API，目标设定拥有该策略才可以访问，其他目标一律不能访问
 *
 * @author fobgochod
 * @since 4.36.3
 */
@Service
public class AccessPathPolicyHandler implements SecurityHandler<AccessPath> {

    @Autowired
    private RamCoreService ramCoreService;

    @Override
    public AccessResult handle(AccessPath request) {
        List<String> policyIds = ramCoreService.findPolicyIdByRoute(request.getApp(), request.getPolicyType().name(), request.getMethod(), request.getPath());
        List<String> targetIds = new ArrayList<>();
        for (String policyId : policyIds) {
            targetIds.addAll(ramCoreService.findTargetByPolicyId(request.getApp(), request.getTargetType().name(), policyId));
        }
        if (targetIds.contains(request.getTargetId())) {
            return AccessResult.allow();
        }
        return AccessResult.next();
    }
}
