/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security.path.handler;

import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=400)
public class FunctionPathPolicyHandler
extends PathPolicyHandler<AccessUser> {
    private static final Logger logger = LoggerFactory.getLogger(FunctionPathPolicyHandler.class);
    private final RamHandlerSupport ramHandlerSupport;

    public FunctionPathPolicyHandler(RamCoreService ramCoreService, RamHandlerSupport ramHandlerSupport) {
        super(ramCoreService);
        this.ramHandlerSupport = ramHandlerSupport;
    }

    @Override
    public AccessResult handle(AccessUser request) {
        if (request.getUserId() != null && request.getTenantId() != null && request.getSysId() != null) {
            MappingRegistry mappingRegistry = this.ramCoreService.getPattern(request.getSysId(), PolicyType.Function.name());
            PatternVO pattern = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
            if (pattern != null) {
                List<String> policyIds = this.ramCoreService.findPolicyIdByRoute(request.getSysId(), PolicyType.Function.name(), pattern.getMethod(), pattern.getPath());
                if (!policyIds.isEmpty()) {
                    boolean match = this.ramHandlerSupport.getUserFunction(request).stream().anyMatch(policyIds::contains);
                    if (match) {
                        return AccessResult.allow();
                    }
                }
                this.handleException(request);
            }
        }
        return AccessResult.next();
    }

    private void handleException(AccessUser request) {
        logger.error("\n{}", (Object)request.securityLog());
        String errMsg = String.format("\u7528\u6237[%s]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u5e94\u7528[%s]\u63a5\u53e3[%s-%s]%s", request.getUserId(), request.getAppId(), request.getMethod(), request.getPath(), StrUtils.isEmpty((String)request.getTableName()) ? "" : String.format("(%s)", request.getTableName()));
        throw new UnauthorizedException((ErrorHandler)RamI18nError.CYBER_SECURITY, errMsg);
    }
}

