/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.web.condition;

import com.digiwin.dap.middle.ram.support.web.condition.AbstractCondition;
import com.digiwin.dap.middle.ram.support.web.condition.MappingInfo;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;

public final class PatternsCondition
extends AbstractCondition {
    private final Set<String> patterns;
    private final UrlPathHelper pathHelper;
    private final PathMatcher pathMatcher;

    public PatternsCondition(String ... patterns) {
        this(Arrays.asList(patterns), null, null);
    }

    public PatternsCondition(String[] patterns, @Nullable UrlPathHelper urlPathHelper, @Nullable PathMatcher pathMatcher) {
        this(Arrays.asList(patterns), urlPathHelper, pathMatcher);
    }

    private PatternsCondition(Collection<String> patterns, @Nullable UrlPathHelper urlPathHelper, @Nullable PathMatcher pathMatcher) {
        this.patterns = Collections.unmodifiableSet(PatternsCondition.prependLeadingSlash(patterns));
        this.pathHelper = urlPathHelper != null ? urlPathHelper : MappingInfo.BuilderConfiguration.defaultInstance;
        this.pathMatcher = pathMatcher != null ? pathMatcher : new AntPathMatcher();
    }

    private static Set<String> prependLeadingSlash(Collection<String> patterns) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(patterns.size());
        for (String pattern : patterns) {
            if (StrUtils.isNotEmpty((String)pattern) && !pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            result.add(pattern);
        }
        return result;
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    protected Collection<String> getContent() {
        return this.patterns;
    }

    public PatternsCondition getMatchingCondition(String lookupPath) {
        if (this.patterns.isEmpty()) {
            return this;
        }
        List<String> matches = this.getMatchingPatterns(lookupPath);
        return !matches.isEmpty() ? new PatternsCondition(matches, this.pathHelper, this.pathMatcher) : null;
    }

    public PatternsCondition getMatchingCondition(HttpServletRequest request) {
        if (this.patterns.isEmpty()) {
            return this;
        }
        String lookupPath = this.pathHelper.getLookupPathForRequest(request);
        List<String> matches = this.getMatchingPatterns(lookupPath);
        return !matches.isEmpty() ? new PatternsCondition(matches, this.pathHelper, this.pathMatcher) : null;
    }

    public List<String> getMatchingPatterns(String lookupPath) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String pattern : this.patterns) {
            String match = this.getMatchingPattern(pattern, lookupPath);
            if (match == null) continue;
            matches.add(match);
        }
        if (matches.size() > 1) {
            matches.sort(this.pathMatcher.getPatternComparator(lookupPath));
        }
        return matches;
    }

    @Nullable
    private String getMatchingPattern(String pattern, String lookupPath) {
        boolean hasSuffix;
        if (pattern.equals(lookupPath)) {
            return pattern;
        }
        boolean bl = hasSuffix = pattern.indexOf(46) != -1;
        if (!hasSuffix && this.pathMatcher.match(pattern + ".*", lookupPath)) {
            return pattern + ".*";
        }
        if (this.pathMatcher.match(pattern, lookupPath)) {
            return pattern;
        }
        if (!pattern.endsWith("/") && this.pathMatcher.match(pattern + "/", lookupPath)) {
            return pattern + "/";
        }
        return null;
    }
}

