package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;

import java.util.ArrayList;
import java.util.List;

/**
 * 访问目标
 *
 * @author fobgochod
 */
public class TargetInfo {

    private TargetType targetType;
    private String targetId;

    public TargetInfo() {
    }

    public TargetInfo(TargetType targetType, String targetId) {
        this.targetType = targetType;
        this.targetId = targetId;
    }

    /**
     * 有序，按照用户->租户->应用依次校验
     *
     * @param request 请求参数
     * @return 目标信息
     */
    public static List<TargetInfo> getTargets(AccessUser request) {
        List<TargetInfo> targets = new ArrayList<>();
        if (request.getUserId() != null) {
            targets.add(new TargetInfo(TargetType.User, request.getUserId()));
        }
        if (request.getTenantId() != null) {
            targets.add(new TargetInfo(TargetType.Tenant, request.getTenantId()));
        }
        if (request.getSysId() != null) {
            targets.add(new TargetInfo(TargetType.Sys, request.getSysId()));
        }
        return targets;
    }

    public TargetType getTargetType() {
        return targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @Override
    public String toString() {
        return targetType + "-" + targetId;
    }
}
