package com.digiwin.dap.middle.ram.domain.remote;

import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 租户应用授权结果
 *
 * @author fobgochod
 */
public class AppAuthResult extends AuthResult {

    public static final String APP_NO_PURCHASE = "noPurchase";
    public static final String APP_EXPIRED = "expired";
    public static final String APP_NO_AUTHORIZATION = "noAuthorization";

    @JsonProperty("isSuccess")
    private boolean success;
    private String noAuthType;
    /**
     * 过期时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime expiredDateTime;
    /**
     * 关联平台应用集合
     */
    private List<String> platformIds;

    /**
     * 授权结果标记，延时处理，方便后续策略放行
     */
    public AuthResult flushAuthType() {
        if (this.success) {
            this.setAuthType(AuthType.AppOk);
        } else if (APP_NO_PURCHASE.equals(this.noAuthType)) {
            this.setAuthType(AuthType.AppNone);
        } else if (APP_EXPIRED.equals(this.noAuthType)) {
            this.setAuthType(AuthType.AppExpired);
        } else if (APP_NO_AUTHORIZATION.equals(this.noAuthType)) {
            this.setAuthType(AuthType.AppNoneUser);
        }
        return this;
    }

    public boolean getSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getNoAuthType() {
        return noAuthType;
    }

    public void setNoAuthType(String noAuthType) {
        this.noAuthType = noAuthType;
    }

    public LocalDateTime getExpiredDateTime() {
        return expiredDateTime;
    }

    public void setExpiredDateTime(LocalDateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public List<String> getPlatformIds() {
        return platformIds;
    }

    public void setPlatformIds(List<String> platformIds) {
        this.platformIds = platformIds;
    }
}