package com.digiwin.dap.middle.ram.support.security.auth.handler;

import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import org.springframework.core.annotation.Order;

/**
 * 调用CAC查询授权信息，授权结果{@link AuthType}
 *
 * @author fobgochod
 */
@Order(10)
public class DoAuthResultPolicyHandler extends AuthPolicyHandler {

    private final RamHandlerSupport ramHandlerSupport;

    public DoAuthResultPolicyHandler(RamHandlerSupport ramHandlerSupport) {
        this.ramHandlerSupport = ramHandlerSupport;
    }

    @Override
    public AuthResult process(AuthResult authResult, AccessUser request) {
        return ramHandlerSupport.getAuthResult(authResult, request);
    }
}
