/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.BaseSid;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyCond;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/policy"})
@RestController
public class RamPolicyController {
    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody Policy body) {
        long sid = this.ramPolicyCrudService.insert(body);
        return StdData.ok((Object)BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        Policy policy = (Policy)this.ramPolicyCrudService.findBySid(body.getSid());
        if (policy == null) {
            return StdData.ok((Object)BaseSid.ok(0L));
        }
        List<GrantVO> policyGrants = this.ramGrantPolicyCrudService.findByPolicySid(body.getSid());
        if (!policyGrants.isEmpty()) {
            String grant = policyGrants.stream().map(o -> o.getType() + "-" + o.getTargetId()).collect(Collectors.joining(","));
            throw new BusinessException(String.format("\u8be5\u7b56\u7565\u5b58\u5728\u6388\u6743\u4fe1\u606f[%s]\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", grant));
        }
        this.ramPolicyCrudService.deleteBySid(body.getSid());
        this.ramPolicyRouteCrudService.deleteByPolicySid(body.getSid());
        this.ramCacheService.policyRemove(policy);
        return StdData.ok((Object)BaseSid.ok(body.getSid()));
    }

    @PostMapping(value={"/mod"})
    public StdData<?> mod(@RequestBody Policy body) {
        Policy policy = (Policy)this.ramPolicyCrudService.findBySid(body.getSid());
        if (policy != null) {
            policy.setName(body.getName());
            this.ramPolicyCrudService.update(policy);
        }
        return StdData.ok((Object)policy);
    }

    @PostMapping(value={"/get"})
    public StdData<?> get(@RequestBody BaseSid body) {
        Policy path = (Policy)this.ramPolicyCrudService.findBySid(body.getSid());
        return StdData.ok((Object)path);
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody PolicyCond body) {
        return StdData.ok(this.ramPolicyCrudService.findByCond(body));
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody PolicyCond body) {
        return StdData.ok(this.ramPolicyCrudService.findByPage(body));
    }
}

