package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.support.cache.LocalCacheHolder;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 本地缓存
 *
 * @author fobgochod
 */
@RequestMapping("/api/ram/v2/cache")
@RestController
public class RamCacheController {

    @PostMapping("/local")
    public StdData<?> get() {
        return StdData.ok(LocalCacheHolder.get());
    }

    @PostMapping("/local/{cacheType}")
    public StdData<?> get(@PathVariable String cacheType) {
        return StdData.ok(LocalCacheHolder.get(cacheType));
    }

    @PostMapping("/local/{cacheType}/{cacheKey}")
    public StdData<?> get(@PathVariable String cacheType,
                          @PathVariable String cacheKey) {
        return StdData.ok(LocalCacheHolder.get(cacheType, cacheKey));
    }

    @PostMapping("/local/del")
    public StdData<?> del() {
        LocalCacheHolder.remove();
        return StdData.ok(LocalCacheHolder.get());
    }

    @PostMapping("/local/del/{cacheType}")
    public StdData<?> del(@PathVariable String cacheType) {
        LocalCacheHolder.remove(cacheType);
        return StdData.ok(LocalCacheHolder.get(cacheType));
    }

    @PostMapping("/local/del/{cacheType}/{cacheKey}")
    public StdData<?> del(@PathVariable String cacheType,
                          @PathVariable String cacheKey) {
        LocalCacheHolder.remove(cacheType, cacheKey);
        return StdData.ok(LocalCacheHolder.get(cacheType, cacheKey));
    }
}
