package com.digiwin.dap.middle.ram.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 策略类型
 *
 * @author fobgochod
 * @see PolicyType
 * @since 4.36.3
 */
public enum ApiPolicyType {

    /**
     * 租户订阅
     */
    ApiSubscribe,
    /**
     * 访问控制-允许，只有唯一一个策略
     */
    ApiAccessAllow,
    /**
     * 访问控制-禁止
     */
    ApiAccessDeny,
    /**
     * 认证方式-签名认证
     */
    ApiAuthSign,
    /**
     * 认证方式-基本认证
     */
    ApiAuthBase;

    public static final String API_ACCESS_ALLOW_ID = "APIAllowlist";
    private static final Map<String, ApiPolicyType> SOLES = new HashMap<>(3);

    static {
        SOLES.put(ApiAccessAllow.name(), ApiAccessAllow);
    }

    public static boolean isSole(String method) {
        return (method != null && SOLES.containsKey(method));
    }


    public static boolean isApi(String name) {
        ApiPolicyType apiPolicyType = valueOfOrNull(name);
        return apiPolicyType == ApiAccessAllow || apiPolicyType == ApiAccessDeny
                || apiPolicyType == ApiAuthSign || apiPolicyType == ApiAuthBase;
    }

    private static ApiPolicyType valueOfOrNull(String name) {
        for (ApiPolicyType value : values()) {
            if (value.name().equals(name)) {
                return value;
            }
        }
        return null;
    }
}
