package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCachePurgeService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamCacheServiceImpl implements RamCacheService {

    @Autowired
    private RamCachePurgeService ramCachePurgeService;
    @Autowired
    private RamGrantCrudService ramGrantCrudService;
    @Autowired
    private RamRouteCrudService ramRouteCrudService;
    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;

    @Override
    public void grantRemove(Grant grant) {
        if (grant == null) {
            return;
        }
        ramCachePurgeService.deletePolicyByTargetId(grant.getApp(), grant.getType(), grant.getTargetId());
    }

    @Override
    public void grantPolicyChange(long grantSid) {
        Grant grant = ramGrantCrudService.findBySid(grantSid);
        this.grantRemove(grant);
    }

    @Override
    public void policyRemove(Policy policy) {
        if (policy == null) {
            return;
        }
        if (PolicyType.AllowList.name().equals(policy.getType())) {
            ramCachePurgeService.deleteRouteByPolicyType(policy.getApp(), policy.getType());
        } else {
            ramCachePurgeService.deleteRouteByPolicyId(policy.getApp(), policy.getId());
        }
    }

    @Override
    public void policyRouteChange(long policySid, long routeSid) {
        Policy policy = ramPolicyCrudService.findBySid(policySid);
        Route route = ramRouteCrudService.findBySid(routeSid);
        if (policy == null || route == null) {
            return;
        }
        if (PolicyType.AllowList.name().equals(policy.getType())
                || PolicyType.Function.name().equals(policy.getType())) {
            ramCachePurgeService.deleteRouteByPolicyType(policy.getApp(), policy.getType());
        }
        if (PolicyType.AcrossTenant.name().equals(policy.getType())
                || PolicyType.Function.name().equals(policy.getType())) {
            ramCachePurgeService.deletePolicyByPath(policy.getApp(), route.getMethod(), route.getPath());
        }
        ramCachePurgeService.deleteRouteByPolicyId(policy.getApp(), policy.getId());
    }

    @Override
    public void routeChange(String appId) {
        ramCachePurgeService.deleteRouteByApp(appId);
    }
}
