package com.digiwin.dap.middle.ram.service.executor.simple;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.executor.RamGroupPolicyExecutor;

import java.util.List;

public class RamGroupPolicySimpleExecutor implements RamGroupPolicyExecutor {

    private final RamExecutorMapper executorMapper;

    public RamGroupPolicySimpleExecutor(RamExecutorMapper executorMapper) {
        this.executorMapper = executorMapper;
    }

    @Override
    public List<PatternVO> findGroupRouteByPolicyType(String app, String policyType) {
        return executorMapper.findGroupRouteByPolicyType(app, policyType);
    }

    @Override
    public List<PatternVO> findGroupRouteByPolicyId(String app, String policyId) {
        return executorMapper.findGroupRouteByPolicyId(app, policyId);
    }

    @Override
    public List<Long> findGroupSidByRoute(String app, String method, String path) {
        return executorMapper.findGroupSidByPath(app, method, path);
    }
}

