package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.access.ApiSubAccessUser;
import com.digiwin.dap.middle.ram.service.core.RamAccessService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.HttpUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * @author geyao
 * @date 2025/11/7
 */
@Validated
@RequestMapping("/api/ram/v2")
@RestController
public class RamAccessController {

    @Autowired
    private RamAccessService ramAccessService;
    @Autowired
    private DapHttpService dapHttpService;

    /**
     * API+CAC
     *
     * @param body    请求参数
     * @param request 请求
     * @return 权限结果
     */
    @PostMapping("/access/api/analyze")
    public StdData<?> api(@Valid @RequestBody ApiSubAccessUser body,
                          HttpServletRequest request) {
        body.getHeaders().putAll(HttpUtils.build(request).getHeaders());
        AuthoredSys authoredSys = dapHttpService.getSysInfo(body.getAppToken());
        body.of(null, authoredSys);
        ramAccessService.api(body);

        return StdData.ok().build();
    }
}
