package com.digiwin.dap.middle.ram.service.access.api;

import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.access.ApiAccessUser;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.service.access.api.handler.RamAccessApiPolicyHandler;
import com.digiwin.dap.middle.ram.service.access.api.handler.RamAuthBaseApiPolicyHandler;
import com.digiwin.dap.middle.ram.service.access.api.handler.RamAuthSignApiPolicyHandler;
import com.digiwin.dap.middle.ram.service.core.RamBaseGroupService;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.security.PolicyChain;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@ConditionalOnProperty(prefix = "dap.middleware", value = "api", havingValue = "true")
public class RamApiPolicyHandlerComposite extends RamApiPolicyHandler implements Ordered {

    private final List<RamApiPolicyHandler> handlers = new ArrayList<>(3);

    public RamApiPolicyHandlerComposite(RamBaseGroupService ramBaseGroupService, RamHandlerSupport ramHandlerSupport) {
        super(ramBaseGroupService);
        this.handlers.add(new RamAccessApiPolicyHandler(ramBaseGroupService, ramHandlerSupport));
        this.handlers.add(new RamAuthBaseApiPolicyHandler(ramBaseGroupService));
        this.handlers.add(new RamAuthSignApiPolicyHandler(ramBaseGroupService, ramHandlerSupport));
    }

    @Override
    public AccessResult handle(ApiAccessUser request) {
        PolicyChain<ApiAccessUser> chain = new PolicyChain<>(handlers);
        return chain.doNextStep(request);
    }

    @Override
    public int getOrder() {
        return PolicyOrder.API.order();
    }
}
