package com.digiwin.dap.middle.ram.service.executor.redis;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.executor.RamGroupPolicyExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class RamGroupPolicyCachingExecutor implements RamGroupPolicyExecutor {

    private final RamGroupPolicyExecutor delegate;

    public RamGroupPolicyCachingExecutor(RamGroupPolicyExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getGroupRouteByPolicyType(#app, #policyType)")
    @Override
    public List<PatternVO> findGroupRouteByPolicyType(String app, String policyType) {
        return delegate.findGroupRouteByPolicyType(app, policyType);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getGroupRouteByPolicyId(#app, #policyId)")
    @Override
    public List<PatternVO> findGroupRouteByPolicyId(String app, String policyId) {
        return delegate.findGroupRouteByPolicyId(app, policyId);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getGroupSidByRoute(#app, #method, #path)")
    @Override
    public List<Long> findGroupSidByRoute(String app, String method, String path) {
        return delegate.findGroupSidByRoute(app, method, path);
    }
}
