package com.digiwin.dap.middle.ram.support;

import com.digiwin.dap.middle.ram.domain.remote.AuthResultVO;
import com.digiwin.dap.middle.ram.domain.remote.DevInfoVO;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;

import java.util.List;

/**
 * 通过appToken检查访问者是否有应用授权
 *
 * @author fobgochod
 */
public interface RamHandlerSupport {

    /**
     * CAC查询授权结果
     * <p>
     * 0: 拥有授权
     * 1: 没有购买应用
     * 2: 已购买，但是应用过期
     * 3: 已购买、但是用户未加入
     *
     * @return {@link AuthType}
     */
    AuthResult getAuthResult(AuthResult authResult, AccessUser request);

    /**
     * 返回用户所有权限URI  应用、模组、作业、按钮
     * <p>
     * 按钮返回allow key的URI
     */
    List<String> getUserFunction(AccessUser request);

    /**
     * CAC查询授权结果
     */
    AuthResultVO getAuthResult(String tenantId, String appId, String method, String path);

    /**
     * 获取开发商密钥
     *
     * @param userToken 用户token
     * @param devKey    密钥对ID
     * @return devSecret
     */
    String getDevSecret(String userToken, String devKey);

    /**
     * 获取应用开发商
     *
     * @param userToken 用户token
     * @param devId     开发商应用APPToken
     * @return 开发商ID
     */
    DevInfoVO getDevTenant(String userToken, String devId);
}
