package com.digiwin.dap.middle.ram.support.cache;

import com.digiwin.dap.middle.ram.constant.RamConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

import java.nio.charset.StandardCharsets;

public class CachePurgeMessageListener implements MessageListener {

    private static final Logger logger = LoggerFactory.getLogger(CachePurgeMessageListener.class);

    @Override
    public void onMessage(Message message, byte[] pattern) {
        String body = new String(message.getBody(), StandardCharsets.UTF_8);
        logger.info("local cache purge: {}", body);

        String[] parts = body.split(RamConstant.MESSAGE_DELIMITER);
        if (parts.length != 2) return;
        String cacheType = parts[0];
        String cacheKey = parts[1];

        LocalCacheHolder.remove(cacheType, cacheKey);
    }
}