package com.digiwin.dap.middle.ram.support.security;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * 按照顺序执行 {@link TargetType}
 * <ol>
 *     <li>白名单 {@link PolicyType#AllowList} 设定了目标权限才可以访问</li>
 *     <li>标准策略 {@link PolicyType#Base} <b>EFFECT属性：</b>0-拒绝访问，1-允许访问</li>
 *     <li>功能权限 {@link PolicyType#Function} 和IAM功能权限绑定，同时传递userToken、appToken才生效</li>
 * </ol>
 *
 * @author fobgochod
 */
public final class PolicyChain<T extends AccessInfo> {

    private static final Logger logger = LoggerFactory.getLogger(PolicyChain.class);

    private final List<? extends SecurityHandler<T>> handlers;
    private final int size;
    private int currentPosition = 0;

    public PolicyChain(List<? extends SecurityHandler<T>> handlers) {
        this.handlers = new ArrayList<>(handlers);
        this.size = handlers.size();
    }

    public AccessResult doNextStep(T request) {
        if (currentPosition == size) {
            return AccessResult.next();
        } else {
            currentPosition++;
            SecurityHandler<T> next = handlers.get(currentPosition - 1);
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking {} {} ({}/{})", request.getId(), next.getClass().getSimpleName(), this.currentPosition, this.size);
            }
            AccessResult result = next.handle(request);
            if (ResultType.IMPLICIT_DENY == result.getResultType()) {
                return doNextStep(request);
            } else {
                return result;
            }
        }
    }
}