/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.api.handler;

import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.access.ApiAccessUser;
import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.domain.enums.ApiPolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.sign.RamSignInfo;
import com.digiwin.dap.middle.ram.domain.sign.VerifyLog;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.access.api.RamApiPolicyHandler;
import com.digiwin.dap.middle.ram.service.core.RamBaseGroupService;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.iam.RedisCache;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapSign;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.VerifyUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class RamAuthSignApiPolicyHandler
extends RamApiPolicyHandler
implements Ordered {
    private final RamHandlerSupport ramHandlerSupport;

    public RamAuthSignApiPolicyHandler(RamBaseGroupService baseGroupService, RamHandlerSupport ramHandlerSupport) {
        super(baseGroupService);
        this.ramHandlerSupport = ramHandlerSupport;
    }

    @Override
    public AccessResult handle(ApiAccessUser request) {
        MappingRegistry mappingRegistry = this.ramBaseGroupService.getPattern(request.getApp(), request.getAppId(), ApiPolicyType.ApiAuthSign.name());
        PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
        if (matched == null) {
            return AccessResult.allow();
        }
        try {
            List<PolicyGrantVO> grants = this.ramBaseGroupService.findGrantsByRoute(request.getApp(), TargetType.Tenant.name(), matched.getMethod(), matched.getPath());
            PolicyGrantVO.checkValidGrant(grants, request);
            this.verifySign(request);
        }
        catch (Exception e) {
            throw new UnauthorizedException((ErrorHandler)ResultType.EXPLICIT_DENY, e.getMessage());
        }
        return AccessResult.allow();
    }

    private void verifySign(ApiAccessUser request) {
        String signHeader = request.getHeaders().get(DapHttpHeaders.DEV_ARGS.getHeader());
        RamSignInfo signInfo = (RamSignInfo)((Object)RamSignInfo.get((String)signHeader, RamSignInfo.class));
        VerifyUtils.sign((DapSign)signInfo, () -> true);
        String devKey = request.getHeaders().get(DapHttpHeaders.DEV_ID.getHeader());
        String devSecret = this.ramHandlerSupport.getDevSecret(request.getUserToken(), devKey);
        boolean verified = SignUtils.verify((Map)JsonUtils.objToMap((Object)((Object)signInfo)), (String)devSecret, (Map[])new Map[0]);
        if (!verified) {
            throw new UnauthorizedException((ErrorHandler)CommonErrorCode.SIGN_INCONSISTENT_SIGNATURE);
        }
        this.verifyLog(devKey, devSecret, request);
    }

    private void verifyLog(String devKey, String devSecret, ApiAccessUser request) {
        VerifyLog verifyLog = new VerifyLog();
        verifyLog.setVerifyDate(LocalDateTime.now());
        verifyLog.setTenantSid(request.getTenantSid());
        verifyLog.setUserSid(request.getUserSid());
        verifyLog.setSysSid(request.getSysSid());
        verifyLog.setSysId(request.getSysId());
        verifyLog.setDevKey(devKey);
        verifyLog.setDevSecret(devSecret);
        RedisCache.setIsvCredentialRecord(request.getTenantSid(), devKey, verifyLog);
    }

    public int getOrder() {
        return PolicyOrder.API_AUTH_SIGN.order();
    }
}

