/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.apisub.handler;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.access.ApiSubAccessUser;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.remote.AuthApiVO;
import com.digiwin.dap.middle.ram.domain.remote.AuthCodeVO;
import com.digiwin.dap.middle.ram.domain.remote.AuthResultVO;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.service.access.apisub.RamApiSubPolicyHandler;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class RamAuthApiSubPolicyHandler
extends RamApiSubPolicyHandler
implements Ordered {
    private final RamHandlerSupport ramHandlerSupport;

    public RamAuthApiSubPolicyHandler(RamHandlerSupport ramHandlerSupport) {
        this.ramHandlerSupport = ramHandlerSupport;
    }

    @Override
    public AccessResult handle(ApiSubAccessUser request) {
        try {
            AuthCodeVO authCode = this.analysis(request);
            AuthResultVO authResult = this.ramHandlerSupport.getAuthResult(authCode.getTenantId(), authCode.getSysId(), request.getMethod(), request.getPath());
            if (RamAuthApiSubPolicyHandler.isNotBelongToCurrentApi(request, authResult, authCode.getSysId())) {
                throw new BusinessException("\u5e94\u7528[" + request.getSysId() + "]\u4e0d\u5c5e\u4e8e\u6280\u80fd\u4e2d\u5fc3\u5546\u54c1\u5f52\u5c5e\u5e94\u7528");
            }
            if (authResult.getPaymentType() == 0 && authResult.getRemainUsage() <= 0) {
                throw new BusinessException((ErrorHandler)RamI18nError.CAC_AUTH_COUNT_ZERO);
            }
            if ("APIQUOTA".equalsIgnoreCase(authResult.getCategory())) {
                AuthResultVO resourceGood;
                if (authResult.getExpiredDateTime() == null || LocalDateTime.now().isAfter(authResult.getExpiredDateTime())) {
                    throw new BusinessException((ErrorHandler)RamI18nError.API_SUBSCRIBE_EXPIRED, new Object[]{authCode.getTenantId()});
                }
                if (CollectionUtils.isEmpty(authResult.getApis())) {
                    throw new BusinessException((ErrorHandler)RamI18nError.API_SUBSCRIBE_NONE, new Object[]{authCode.getTenantId(), request.getMethod(), request.getPath()});
                }
                AuthApiVO authApiVO = authResult.getApis().stream().filter(e -> e.getExpiredTime() != null && e.getExpiredTime().isAfter(LocalDateTime.now())).findFirst().orElse(null);
                if (authApiVO == null) {
                    throw new BusinessException((ErrorHandler)RamI18nError.API_SUBSCRIBE_EXPIRED, new Object[]{authCode.getTenantId()});
                }
                if (authResult.getPaymentType() == 4 && ((resourceGood = authResult.getResourceGood()) == null || resourceGood.getRemainUsage() == null || resourceGood.getRemainUsage() <= 0)) {
                    throw new BusinessException((ErrorHandler)RamI18nError.CAC_AUTH_COUNT_ZERO);
                }
            }
        }
        catch (Exception e2) {
            throw new UnauthorizedException((ErrorHandler)ResultType.EXPLICIT_DENY, e2.getMessage());
        }
        return AccessResult.next();
    }

    private static boolean isNotBelongToCurrentApi(AccessUser request, AuthResultVO authResult, String currentApiId) {
        String sysId = request.getSysId();
        if (sysId != null && sysId.equals(currentApiId)) {
            return false;
        }
        return !"APIQUOTA".equalsIgnoreCase(authResult.getCategory()) && authResult.getApiGoods() != null && authResult.getApiGoods().stream().noneMatch(p -> p.getCode().equals(sysId));
    }

    private AuthCodeVO analysis(AccessUser request) {
        try {
            String secretKey = request.getHeaders().get(DapHttpHeaders.SECRET_KEY.getHeader());
            String[] content = AES.decryptCBC((String)secretKey, (String)KeyConstant.OTHER).split("@#\\$%\\^_");
            if (content.length != 4) {
                throw new BusinessException("\u975e\u6cd5\u6388\u6743\u7801\uff1a" + secretKey);
            }
            AuthCodeVO authCode = new AuthCodeVO();
            authCode.setTenantId(content[0]);
            authCode.setSysId(content[1]);
            authCode.setUserId(content[2]);
            Instant instant = Instant.ofEpochMilli(Long.parseLong(content[3]));
            authCode.setTimestamp(LocalDateTime.ofInstant(instant, ZoneId.systemDefault()));
            return authCode;
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)RamI18nError.IAM_AUTH_CODE_INVALID, new Object[]{e.getMessage()});
        }
    }

    public int getOrder() {
        return PolicyOrder.API_SUB_AUTH.order();
    }
}

