/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.iam;

import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.remote.AppAuthResult;
import com.digiwin.dap.middle.ram.domain.remote.AuthResultVO;
import com.digiwin.dap.middle.ram.domain.remote.DevInfoVO;
import com.digiwin.dap.middle.ram.domain.remote.Function;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.RamCacheSupport;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.iam.RedisCache;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.DapException;
import com.digiwin.dap.middleware.exception.StdError;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class DefaultRamHandlerSupport
implements RamHandlerSupport {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRamHandlerSupport.class);
    private static final String USER_WHITE_LIST = "integration;virtual";
    @Autowired
    private DapEnv dapEnv;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate retryRestTemplate;
    private RamCacheSupport ramCacheSupport;

    public DefaultRamHandlerSupport() {
    }

    public DefaultRamHandlerSupport(RamCacheSupport ramCacheSupport) {
        this.ramCacheSupport = ramCacheSupport;
    }

    @Override
    public AuthResult getAuthResult(AuthResult authResult, AccessUser request) {
        AppAuthResult result = RedisCache.getAuthResult(request.getTenantId(), request.getUserId(), request.getSysId());
        if (result == null && (result = this.getAuthResult(request.getTenantId(), request.getUserId(), request.getSysId(), request.isPlatform(), authResult.getTenants(), !USER_WHITE_LIST.contains(request.getUserId()))).getSuccess()) {
            RedisCache.setAuthResult(result, request.getUserId(), request.getSysId());
        }
        return result.flushAuthType();
    }

    @Override
    public List<String> getUserFunction(AccessUser request) {
        return this.getUserFunction(request.getUserId(), request.getTenantId(), request.getSysId(), request.getUserToken()).uris(request.getSysId());
    }

    @Override
    public AuthResultVO getAuthResult(String tenantId, String appId, String method, String path) {
        String url = this.dapEnv.getCacUri() + "/api/cac/v4/authorizations/tenant/goods/check";
        HashMap<String, String> body = new HashMap<String, String>();
        try {
            body.put("tenantId", tenantId);
            body.put("goodsCode", appId);
            body.put("method", method);
            body.put("path", path);
            HttpEntity httpEntity = new HttpEntity(body);
            ResponseEntity result = this.retryRestTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<AuthResultVO>>(){}, new Object[0]);
            return (AuthResultVO)((StdData)result.getBody()).getData();
        }
        catch (HttpStatusCodeException e) {
            StdError stdError = (StdError)JsonUtils.jsonToObj((String)e.getResponseBodyAsString(), StdError.class);
            throw new UnauthorizedException(stdError, url, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, url, e);
        }
    }

    @Override
    public String getDevSecret(String userToken, String devKey) {
        String result = RedisCache.getDevSecret(devKey);
        if (result != null) {
            return result;
        }
        try {
            String url = this.dapEnv.getIamUri() + "/api/iam/v1/isv/credential/secret/current";
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("devKey", devKey);
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<DevInfoVO>>(){}, new Object[0]);
            String appSecret = ((DevInfoVO)((StdData)responseEntity.getBody()).getData()).getAppSecret();
            if (appSecret == null) {
                throw new BusinessException((ErrorHandler)RamI18nError.API_DEV_SECRET_NONE, new Object[]{devKey});
            }
            RedisCache.setDevSecret(devKey, appSecret);
            return appSecret;
        }
        catch (DapException e) {
            throw e;
        }
        catch (HttpStatusCodeException e) {
            StdError stdError = (StdError)JsonUtils.jsonToObj((String)e.getResponseBodyAsString(), StdError.class);
            throw new BusinessException(stdError);
        }
        catch (Exception e) {
            throw new BusinessException("\u3010\u8c03\u7528IAM\u3011\u83b7\u53d6devSecret\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public DevInfoVO getDevTenant(String userToken, String devId) {
        DevInfoVO result = RedisCache.getDevTenant(devId);
        if (result != null) {
            return result;
        }
        try {
            String url = this.dapEnv.getIamUri() + "/api/iam/v2/dev/app/one";
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("id", devId);
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<DevInfoVO>>(){}, new Object[0]);
            DevInfoVO devInfoVO = (DevInfoVO)((StdData)responseEntity.getBody()).getData();
            if (devInfoVO == null) {
                throw new BusinessException((ErrorHandler)RamI18nError.API_DEV_TENANT_NONE, new Object[]{devId});
            }
            RedisCache.setDevTenant(devId, devInfoVO);
            return devInfoVO;
        }
        catch (DapException e) {
            throw e;
        }
        catch (HttpStatusCodeException e) {
            StdError stdError = (StdError)JsonUtils.jsonToObj((String)e.getResponseBodyAsString(), StdError.class);
            throw new BusinessException(stdError);
        }
        catch (Exception e) {
            throw new BusinessException(String.format("\u3010\u8c03\u7528IAM\u3011\u83b7\u53d6\u5e94\u7528[%s]\u7684\u5f00\u53d1\u5546\u4fe1\u606f\u5931\u8d25", devId), (Throwable)e);
        }
    }

    private AppAuthResult getAuthResult(String tenantId, String userId, String appId, boolean platform, List<String> tenants, boolean checkUserAuth) {
        try {
            String url = this.dapEnv.getCacUri() + "/api/cac/v4/authorizations/tenant/user/goods/check";
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("tenantId", tenantId);
            body.put("userId", userId);
            body.put("goodsCode", appId);
            body.put("tenants", tenants);
            body.put("checkUserAuth", Boolean.toString(checkUserAuth));
            if (platform) {
                body.put("apps", this.ramCacheSupport.getSysByPlatformId(appId));
            } else {
                body.put("platformApps", this.ramCacheSupport.getPlatformSysBySysId(appId));
            }
            HttpEntity httpEntity = new HttpEntity(body);
            return (AppAuthResult)((Object)this.retryRestTemplate.postForObject(url, (Object)httpEntity, AppAuthResult.class, new Object[0]));
        }
        catch (Exception e) {
            String message = String.format("\u83b7\u53d6\u79df\u6237[%s]\u7528\u6237[%s]\u7684\u5e94\u7528[%s]\u6388\u6743\u4fe1\u606f\u5931\u8d25", tenantId, userId, appId);
            throw new UnauthorizedException((ErrorHandler)RamI18nError.CAC_AUTH_GET_FAIL, message, 411005, (Throwable)e);
        }
    }

    private Function getUserFunction(String userId, String tenantId, String sysId, String userToken) {
        String uri = this.dapEnv.getIamUri() + "/api/iam/v2/permission/user/all";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, String> body = new HashMap<String, String>(3);
            body.put("tenantId", tenantId);
            body.put("userId", userId);
            body.put("target", "drn:iam:app:" + sysId);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            return (Function)this.retryRestTemplate.postForObject(uri, (Object)request, Function.class, new Object[0]);
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, uri, e);
        }
    }
}

