package com.digiwin.dap.middle.ram.domain.vo;

import com.digiwin.dap.middleware.commons.util.StrUtils;

import java.util.Objects;

/**
 * API缓存
 *
 * @author fobgochod
 */
public class PatternVO {

    private String method;
    private String path;
    private String tableName;
    private Boolean effect;
    private String policyId;

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Boolean getEffect() {
        return effect;
    }

    public void setEffect(Boolean effect) {
        this.effect = effect;
    }

    public String getPolicyId() {
        return policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public String path() {
        return StrUtils.isNotEmpty(tableName) ? path + "/" + tableName : path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PatternVO patternVO = (PatternVO) o;
        return Objects.equals(method, patternVO.method) && path.equals(patternVO.path) && Objects.equals(tableName, patternVO.tableName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(method, path, tableName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (StrUtils.isNotEmpty(method)) {
            builder.append(method);
        }
        builder.append("-").append(path);
        if (StrUtils.isNotEmpty(tableName)) {
            builder.append("/").append(tableName);
        }
        builder.append("}");
        return builder.toString();
    }
}
