package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.vo.condition.GrantCond;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.entity.Grant;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamGrantMapper {

    int insert(@Param("entity") Grant entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Grant entity);

    Grant findBySid(@Param("sid") long sid);

    boolean exists(@Param("sid") long sid);

    Grant findByTypeAndTarget(@Param("type") String type, @Param("targetId") String targetId);

    long countByPage(@Param("cond") GrantCond cond);

    List<GrantVO> findByCond(@Param("cond") GrantCond cond);

    List<GrantVO> findByPage(@Param("cond") GrantCond cond, @Param("pageable") Pageable pageable);
}
