package com.digiwin.dap.middle.ram.support;

import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 按应用缓存所有的路由信息
 *
 * @author fobgochod
 */
@Component
public class MappingInfoRegistry implements InitializingBean {

    private final MappingRegistry internalMappingRegistry = new MappingRegistry();
    private final Map<String, MappingRegistry> appMappingRegistries = new ConcurrentHashMap<>();


    @Override
    public void afterPropertiesSet() {
        initMappingInfos();
    }

    private void initMappingInfos() {

    }

    public MappingRegistry getMappingRegistry(String app) {
        if (GlobalConstants.MIDDLEWARE.equals(app)) {
            return internalMappingRegistry;
        }
        if (!appMappingRegistries.containsKey(app)) {
            appMappingRegistries.put(app, new MappingRegistry());
        }
        return appMappingRegistries.get(app);
    }
}
