/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.iam;

import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.remote.AppAuthResult;
import com.digiwin.dap.middle.ram.domain.remote.Function;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.RamCacheSupport;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.iam.RedisCache;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefaultRamHandlerSupport
implements RamHandlerSupport {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRamHandlerSupport.class);
    private static final String USER_WHITE_LIST = "integration;virtual";
    @Autowired
    private DapEnv dapEnv;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate retryRestTemplate;
    private RamCacheSupport ramCacheSupport;

    public DefaultRamHandlerSupport() {
    }

    public DefaultRamHandlerSupport(RamCacheSupport ramCacheSupport) {
        this.ramCacheSupport = ramCacheSupport;
    }

    @Override
    public AuthResult getAuthResult(AuthResult authResult, AccessUser request) {
        AppAuthResult result = RedisCache.getAuthResult(request.getTenantId(), request.getUserId(), request.getSysId());
        if (result == null && (result = this.getAuthResult(request.getTenantId(), request.getUserId(), request.getSysId(), request.isPlatform(), authResult.getTenants(), !USER_WHITE_LIST.contains(request.getUserId()))).getSuccess()) {
            RedisCache.setAuthResult(result, request.getUserId(), request.getSysId());
        }
        return result.flushAuthType();
    }

    @Override
    public List<String> getUserFunction(AccessUser request) {
        return this.getUserFunction(request.getUserId(), request.getTenantId(), request.getSysId(), request.getUserToken()).uris(request.getSysId());
    }

    private AppAuthResult getAuthResult(String tenantId, String userId, String appId, boolean platform, List<String> tenants, boolean checkUserAuth) {
        try {
            String url = this.dapEnv.getCacUri() + "/api/cac/v4/authorizations/tenant/user/goods/check";
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("tenantId", tenantId);
            body.put("userId", userId);
            body.put("goodsCode", appId);
            body.put("tenants", tenants);
            body.put("checkUserAuth", Boolean.toString(checkUserAuth));
            if (platform) {
                body.put("apps", this.ramCacheSupport.getSysByPlatformId(appId));
            } else {
                body.put("platformApps", this.ramCacheSupport.getPlatformSysBySysId(appId));
            }
            HttpEntity httpEntity = new HttpEntity(body);
            return (AppAuthResult)((Object)this.retryRestTemplate.postForObject(url, (Object)httpEntity, AppAuthResult.class, new Object[0]));
        }
        catch (Exception e) {
            String message = String.format("\u83b7\u53d6\u79df\u6237[%s]\u7528\u6237[%s]\u7684\u5e94\u7528[%s]\u6388\u6743\u4fe1\u606f\u5931\u8d25", tenantId, userId, appId);
            throw new UnauthorizedException((ErrorHandler)RamI18nError.CAC_AUTH_GET_FAIL, message, 411005, (Throwable)e);
        }
    }

    private Function getUserFunction(String userId, String tenantId, String sysId, String userToken) {
        String uri = this.dapEnv.getIamUri() + "/api/iam/v2/permission/user/all";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, Object> body = new HashMap<String, Object>(3);
            body.put("tenantId", tenantId);
            body.put("userId", userId);
            body.put("target", "drn:iam:app:" + sysId);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            return (Function)this.retryRestTemplate.postForObject(uri, (Object)request, Function.class, new Object[0]);
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, uri, e);
        }
    }
}

