/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.web.condition;

import com.digiwin.dap.middle.ram.support.web.condition.HttpMethod;
import com.digiwin.dap.middle.ram.support.web.condition.MethodsCondition;
import com.digiwin.dap.middle.ram.support.web.condition.PatternsCondition;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;

public final class MappingInfo {
    @Nullable
    private final String name;
    private final PatternsCondition patternsCondition;
    private final MethodsCondition methodsCondition;

    public MappingInfo(@Nullable String name, @Nullable PatternsCondition patterns, @Nullable MethodsCondition methods) {
        this.name = StrUtils.hasText((String)name) ? name : null;
        this.patternsCondition = patterns != null ? patterns : new PatternsCondition(new String[0]);
        this.methodsCondition = methods != null ? methods : new MethodsCondition(new HttpMethod[0]);
    }

    public MappingInfo(@Nullable PatternsCondition patterns, @Nullable MethodsCondition methods) {
        this(null, patterns, methods);
    }

    public MappingInfo(MappingInfo info) {
        this(info.name, info.patternsCondition, info.methodsCondition);
    }

    public static Builder paths(String ... paths) {
        return new DefaultBuilder(paths);
    }

    public static HttpMethod[] getMethod(String method) {
        try {
            return new HttpMethod[]{HttpMethod.valueOf(method)};
        }
        catch (Exception e) {
            return new HttpMethod[0];
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public PatternsCondition getPatternsCondition() {
        return this.patternsCondition;
    }

    public MethodsCondition getMethodsCondition() {
        return this.methodsCondition;
    }

    public MappingInfo getMatchingCondition(String method, String lookupPath) {
        MethodsCondition methods = this.methodsCondition.getMatchingCondition(method);
        if (methods == null) {
            return null;
        }
        PatternsCondition patterns = this.patternsCondition.getMatchingCondition(lookupPath);
        if (patterns == null) {
            return null;
        }
        return new MappingInfo(this.name, patterns, methods);
    }

    @Nullable
    public MappingInfo getMatchingCondition(HttpServletRequest request) {
        MethodsCondition methods = this.methodsCondition.getMatchingCondition(request);
        if (methods == null) {
            return null;
        }
        PatternsCondition patterns = this.patternsCondition.getMatchingCondition(request);
        if (patterns == null) {
            return null;
        }
        return new MappingInfo(this.name, patterns, methods);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MappingInfo)) {
            return false;
        }
        MappingInfo otherInfo = (MappingInfo)other;
        return this.patternsCondition.equals(otherInfo.patternsCondition) && this.methodsCondition.equals(otherInfo.methodsCondition);
    }

    public int hashCode() {
        return this.patternsCondition.hashCode() * 31 + this.methodsCondition.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (!this.methodsCondition.isEmpty()) {
            Set<HttpMethod> httpMethods = this.methodsCondition.getMethods();
            builder.append(httpMethods.size() == 1 ? httpMethods.iterator().next() : httpMethods);
        }
        if (!this.patternsCondition.isEmpty()) {
            Set<String> patterns = this.patternsCondition.getPatterns();
            builder.append(" ").append(patterns.size() == 1 ? patterns.iterator().next() : patterns);
        }
        builder.append('}');
        return builder.toString();
    }

    private static class DefaultBuilder
    implements Builder {
        private String[] paths = new String[0];
        private HttpMethod[] methods = new HttpMethod[0];
        @Nullable
        private String mappingName;
        private BuilderConfiguration options = new BuilderConfiguration();

        public DefaultBuilder(String ... paths) {
            this.paths = paths;
        }

        @Override
        public Builder paths(String ... paths) {
            this.paths = paths;
            return this;
        }

        @Override
        public DefaultBuilder methods(HttpMethod ... methods) {
            this.methods = methods;
            return this;
        }

        @Override
        public Builder options(BuilderConfiguration options) {
            this.options = options;
            return this;
        }

        @Override
        public MappingInfo build() {
            PatternsCondition patternsCondition = new PatternsCondition(this.paths, this.options.getUrlPathHelper(), this.options.getPathMatcher());
            return new MappingInfo(this.mappingName, patternsCondition, new MethodsCondition(this.methods));
        }
    }

    public static class BuilderConfiguration {
        public static final UrlPathHelper defaultInstance = new UrlPathHelper();
        private UrlPathHelper urlPathHelper;
        private PathMatcher pathMatcher;

        public UrlPathHelper getUrlPathHelper() {
            return this.urlPathHelper;
        }

        public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
            this.urlPathHelper = urlPathHelper;
        }

        public PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }

        public void setPathMatcher(PathMatcher pathMatcher) {
            this.pathMatcher = pathMatcher;
        }
    }

    public static interface Builder {
        public Builder paths(String ... var1);

        public Builder methods(HttpMethod ... var1);

        public Builder options(BuilderConfiguration var1);

        public MappingInfo build();
    }
}

