package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.RouteCond;
import com.digiwin.dap.middle.ram.entity.Route;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamRouteMapper {

    int insert(@Param("entity") Route entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Route entity);

    Route findBySid(@Param("sid") long sid);

    boolean existsBySid(@Param("sid") long sid);

    Route findByAppAndMethodAndPath(@Param("app") String app, @Param("method") String method, @Param("path") String path);

    long countByPage(@Param("cond") RouteCond cond);

    List<RouteVO> findByCond(@Param("cond") RouteCond cond);

    List<RouteVO> findByPage(@Param("cond") RouteCond cond, @Param("pageable") Pageable pageable);
}
