package com.digiwin.dap.middle.ram.service.access.apisub.handler;

import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.access.ApiSubAccessUser;
import com.digiwin.dap.middle.ram.domain.access.AuthMode;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.sign.ApiSignInfo;
import com.digiwin.dap.middle.ram.service.access.apisub.RamApiSubPolicyHandler;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.VerifyUtils;
import org.springframework.core.Ordered;

public class RamSignApiSubPolicyHandler extends RamApiSubPolicyHandler implements Ordered {

    private final RamHandlerSupport ramHandlerSupport;

    public RamSignApiSubPolicyHandler(RamHandlerSupport ramHandlerSupport) {
        this.ramHandlerSupport = ramHandlerSupport;
    }

    @Override
    public AccessResult handle(ApiSubAccessUser request) {
        if (request.getAuthMode() == AuthMode.SIGN_COUNT) {
            try {
                verifySign(request);
            } catch (Exception e) {
                throw new UnauthorizedException(ResultType.EXPLICIT_DENY, e.getMessage());
            }
        }
        return AccessResult.next();
    }

    private void verifySign(ApiSubAccessUser request) {
        String signHeader = request.getHeaders().get(DapHttpHeaders.DEV_ARGS.getHeader());
        ApiSignInfo signInfo;
        try {
            signInfo = ApiSignInfo.get(signHeader, ApiSignInfo.class);
        } catch (Exception e) {
            throw new UnauthorizedException(CommonErrorCode.SIGN_HEADER_ARG_PARSING_FAILED, new Object[]{signHeader});
        }
        VerifyUtils.sign(signInfo, () -> true);
        String devKey = request.getHeaders().get(DapHttpHeaders.DEV_ID.getHeader());
        String devSecret = ramHandlerSupport.getDevSecret(request.getUserToken(), devKey);

        signInfo.setMethod(request.getMethod());
        signInfo.setPath(request.getPath());
        signInfo.setDevKey(devKey);
        signInfo.setUserToken(request.getUserToken());
        boolean verified = SignUtils.verify(JsonUtils.objToMap(signInfo), devSecret);
        if (!verified) {
            throw new UnauthorizedException(CommonErrorCode.SIGN_INCONSISTENT_SIGNATURE);
        }
    }

    @Override
    public int getOrder() {
        return PolicyOrder.API_SUB_SIGN.order();
    }
}
