package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.constant.RamConstant;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.core.RamBaseGroupService;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.service.executor.RamGroupGrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.RamGroupPolicyExecutor;
import com.digiwin.dap.middle.ram.support.MappingInfoRegistry;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核心API
 * <p>
 * 查询目标、策略、路由之间的关系
 *
 * @author fobgochod
 * @since 4.36.3
 */
@Service
public class RamBaseGroupServiceImpl implements RamBaseGroupService {

    @Autowired
    private RamCoreService ramCoreService;
    @Autowired
    private RamGroupGrantExecutor ramGroupGrantExecutor;
    @Autowired
    private RamGroupPolicyExecutor ramGroupPolicyExecutor;
    @Autowired
    private MappingInfoRegistry mappingInfoRegistry;

    @Override
    public MappingRegistry getPattern(String app, String appId, String policyType) {
        List<PatternVO> patterns = ramGroupPolicyExecutor.findGroupRouteByPolicyType(app, policyType);
        return new MappingRegistry(patterns, mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public Statement getPolicyRoute(String app, String appId, String policyType, String targetType, String targetId) {
        List<PatternVO> routes = new ArrayList<>();
        List<String> policyIds = ramCoreService.findPolicyId(app, policyType, targetType, targetId);
        for (String policyId : policyIds) {
            routes.addAll(ramGroupPolicyExecutor.findGroupRouteByPolicyId(app, policyId));
        }
        return new Statement(routes, mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public List<PolicyGrantVO> findGrantsByRoute(String app, String targetType, String method, String path) {
        List<Long> groupSids = ramGroupPolicyExecutor.findGroupSidByRoute(app, method, path);
        List<String> policyIds = groupSids.stream().map(p -> RamConstant.SUBSCRIBE_POLICY_PREFIX + p).collect(Collectors.toList());
        return this.findGrantTargetByPolicyIds(app, targetType, policyIds);
    }

    private List<PolicyGrantVO> findGrantTargetByPolicyIds(String app, String targetType, List<String> policyIds) {
        return policyIds.stream()
                .map(policyId -> ramGroupGrantExecutor.findPolicyGrantByPolicyId(app, targetType, policyId))
                .flatMap(Collection::stream)
                .collect(Collectors.toList());
    }

    @Override
    public boolean existGrant(String app, String targetType, String policyId, String targetId) {
        PolicyGrantVO grant = ramGroupGrantExecutor.findGrantByPolicyIdAndTargetId(app, targetType, policyId, targetId);
        return grant != null;
    }
}
