package com.digiwin.dap.middle.ram.service.executor;


import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.domain.enums.ApiPolicyType;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;

import java.util.List;

public interface RamGroupGrantExecutor {

    /**
     * 获取指定策略的授权目标ID
     * <p>
     * 策略类型 {@link PolicyType#AcrossTenant}  {@link ApiPolicyType#ApiAccessAllow} {@link ApiPolicyType#ApiSubscribe}
     *
     * @param app        应用ID
     * @param targetType 目标类型 {@link TargetType}
     * @param policyId   策略ID
     * @return 策略的关联的目标
     */
    List<PolicyGrantVO> findPolicyGrantByPolicyId(String app, String targetType, String policyId);


    /**
     * 目标是否授权指定策略
     *
     * @param app        应用ID
     * @param targetType 目标类型 {@link TargetType}
     * @param policyId   策略ID
     * @param targetId   目标ID
     * @return 是否授权
     */
    PolicyGrantVO findGrantByPolicyIdAndTargetId(String app, String targetType, String policyId, String targetId);
}

