package com.digiwin.dap.middle.ram.service.executor;


import com.digiwin.dap.middle.ram.domain.enums.ApiPolicyType;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;

import java.util.List;

public interface RamGroupPolicyExecutor {

    /**
     * 获取特定策略类型下的路由配置信息
     *
     * @param app        应用ID
     * @param policyType {@link ApiPolicyType#ApiAccessAllow}、{@link ApiPolicyType#ApiAuthSign}、{@link ApiPolicyType#ApiAuthBase}
     * @return 指定类型策略对应的路由
     */
    List<PatternVO> findGroupRouteByPolicyType(String app, String policyType);

    /**
     * 根据策略ID获取路由配置信息
     * <p>
     * 支持类型 {@link ApiPolicyType#ApiAccessAllow}、{@link ApiPolicyType#ApiAccessDeny}
     *
     * @param app      应用ID
     * @param policyId 策略ID
     * @return 指定策略ID对应的路由
     */
    List<PatternVO> findGroupRouteByPolicyId(String app, String policyId);

    /**
     * 通过方法和路由查询分组SID
     * <p>
     * 支持类型 {@link ApiPolicyType#ApiSubscribe}
     *
     * @param app    应用ID
     * @param method 方法
     * @param path   路由
     * @return 分组SID
     */
    List<Long> findGroupSidByRoute(String app, String method, String path);
}

