package com.digiwin.dap.middle.ram.service.executor.local;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.service.executor.RamPolicyExecutor;
import com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder;
import com.digiwin.dap.middle.ram.support.cache.LocalCacheHolder;

import java.util.List;

public class RamPolicyLocalCacheExecutor implements RamPolicyExecutor {

    private final String appName;
    private final RamPolicyExecutor delegate;

    public RamPolicyLocalCacheExecutor(String appName, RamPolicyExecutor delegate) {
        this.appName = appName;
        this.delegate = delegate;
    }

    @Override
    public List<PatternVO> findRouteByPolicyId(String app, String policyId) {
        String key = CacheKeyBuilder.getRouteByPolicyId(appName, app, policyId);
        return LocalCacheHolder.ROUTE_BY_POLICY_ID.computeIfAbsent(key, k -> delegate.findRouteByPolicyId(app, policyId));
    }

    @Override
    public List<PatternVO> findRouteByPolicyType(String app, String policyType) {
        String key = CacheKeyBuilder.getRouteByPolicyType(appName, app, policyType);
        return LocalCacheHolder.ROUTE_BY_POLICY_TYPE.computeIfAbsent(key, k -> delegate.findRouteByPolicyType(app, policyType));
    }

    @Override
    public List<PolicyVO> findPolicyByPath(String app, String method, String path) {
        String key = CacheKeyBuilder.getPolicyByPath(appName, app, method, path);
        return LocalCacheHolder.POLICY_BY_PATH.computeIfAbsent(key, k -> delegate.findPolicyByPath(app, method, path));
    }
}
