package com.digiwin.dap.middle.ram.service.executor.redis;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.executor.RamRouteExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class RamRouteRedisCacheExecutor implements RamRouteExecutor {

    private final RamRouteExecutor delegate;

    public RamRouteRedisCacheExecutor(RamRouteExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getRouteByApp(#app)")
    @Override
    public List<PatternVO> findRouteByApp(String app) {
        return delegate.findRouteByApp(app);
    }
}