/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.access.ApiSubAccessUser;
import com.digiwin.dap.middle.ram.service.core.RamAccessService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.HttpUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RequestMapping(value={"/api/ram/v2"})
@RestController
public class RamAccessController {
    @Autowired
    private RamAccessService ramAccessService;
    @Autowired
    private DapHttpService dapHttpService;

    @PostMapping(value={"/access/api/analyze"})
    public StdData<?> api(@Valid @RequestBody ApiSubAccessUser body, HttpServletRequest request) {
        body.getHeaders().putAll(HttpUtils.build((HttpServletRequest)request).getHeaders());
        AuthoredSys authoredSys = this.dapHttpService.getSysInfo(body.getAppToken());
        body.of(null, authoredSys);
        this.ramAccessService.api(body);
        return StdData.ok().build();
    }
}

